<?php
header('Content-type: application/json');

//error_reporting(E_ALL);

include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once 'config.php';

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
  die('This file cannot be accessed directly!');
}

## Read value


// if (!isset($_POST['order_id'], $_POST['reference'])) {
//   echo json_encode(['success' => false, 'error' => 'Invalid request']);
//   exit;
// }
$order_id  = (int) $_POST['order_id'];
$reference = trim($_POST['reference']);




$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");


$dashboard = new MarketplaceDashboard($db);
//echo json_encode(['success' => false, 'message' => $order_id, 'blee' => $reference]);

$getOrder = $dashboard->getOrderForVerification($order_id);
//echo json_encode(['success' => false, 'message' => $reference]);


if (!$getOrder['success']) {
  echo json_encode($getOrder);
  exit;
}
//echo json_encode(['success' => true, 'message' => $getOrder]);


$order = $getOrder['order'];
$privkey = "sk_test_1653e28f4ddca5363e71b207e49b7915867c1b01";
// Verify transaction with Paystack
$base_url = 'https://api.paystack.co/transaction/verify/';
$url = $base_url . $reference;
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  'Authorization: Bearer ' . $privkey
]);
$response = curl_exec($ch);
$curlError = curl_error($ch);
curl_close($ch);

if ($curlError) {
  echo json_encode(['success' => false, 'message' => 'cURL Error: ' . $curlError, 'url' => $url]);
  exit();
}

$result = json_decode($response, true);
if (!$result || !isset($result['data'])) {
  echo json_encode(['success' => false, 'message' => 'Invalid response from Paystack']);
  exit();
}

// Check if transaction was successful
$payData = $result['data'];


if (
  $payData['status'] === 'success'
) {
  $amountPaid = $payData['amount'] / 100;


  if ((float)$amountPaid < (float)$order['subtotal_amount']) {
    echo json_encode([
      'success' => true,
      'data' => 'Paid amount is less than order total'
    ]);
    exit;
  }

  $getOrder = $dashboard->markOrderPaid($order_id, $reference);

  echo json_encode([
    'success' => true,
    'data' => $getOrder
  ]);
} else {

  echo json_encode([
    'success' => true,
    'date' => "got here"
  ]);
}
exit();
